Rem CornerEffects.vbs
Rem An InDesign VBScript
Rem
Rem Applies corner effects by redrawing the object.
Rem
Rem For more information on InDesign scripting, go to http://www.adobe.com/products/indesign/scripting/index.html
Rem Or visit the InDesign Scripting User to User forum at http://www.adobeforums.com.
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2024")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count > 0 Then
	    If myInDesign.Selection.Count > 0 Then
	        Set mySelection = myInDesign.Selection
	        ReDim myObjectList(0)
	        For myCounter = 1 To mySelection.Count
	            Select Case TypeName(mySelection.Item(myCounter))
	                Case "Rectangle", "Oval", "Polygon", "GraphicLine", "TextFrame"
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = mySelection.Item(myCounter)
	                Case Else
	            End Select
	        Next
	        If Not (IsEmpty(myObjectList(0))) Then
	            myDisplayDialog myInDesign, myObjectList
	        Else
	            MsgBox "Nothing is selected. Please select a rectangle, oval, polygon, text frame, or graphic line and try again."
	        End If
	    Else
	        MsgBox "Nothing is selected. Please select a rectangle, oval, polygon, text frame, or graphic line and try again."
	    End If
	Else
	    MsgBox "Please open a document, select an object, and try again."
	End If
End function
Function myDisplayDialog(myInDesign, myObjectList)
    myStringList = Array("all points", "first point", "last point", "second point", "third point", "fourth point", "first two", "second and third", "last two", "odd points", "even points")
    Rem Store the current measurement units.
    myOldXUnits = myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits
    myOldYUnits = myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits
    Rem Set the measurement units to points.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = idMeasurementUnits.idPoints
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = idMeasurementUnits.idPoints
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.Name = "CornerEffects"
    With myDialog
        With .DialogColumns.Add
            With .BorderPanels.Add
                With .StaticTexts.Add
                    .StaticLabel = "Corner Type:"
                End With
                Set myCornerEffectButtons = .RadiobuttonGroups.Add
                With myCornerEffectButtons
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Rounded"
                        .CheckedState = True
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Inverse Rounded"
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Bevel"
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Inset"
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Fancy"
                    End With
                End With
            End With
            With .BorderPanels.Add
                With .DialogColumns.Add
                    With .StaticTexts.Add
                        .StaticLabel = "Options:"
                    End With
                End With
                With .DialogColumns.Add
                    With .DialogRows.Add
                        With .DialogColumns.Add
                            With .StaticTexts.Add
                                .StaticLabel = "Offset:"
                                .MinWidth = 60
                            End With
                        End With
                        With .DialogColumns.Add
                            Set myOffsetEditbox = .MeasurementEditboxes.Add
                            With myOffsetEditbox
                                .EditValue = 12
                            End With
                        End With
                    End With
                    With .DialogRows.Add
                        With .DialogColumns.Add
                            With .StaticTexts.Add
                                .StaticLabel = "Pattern:"
                                .MinWidth = 60
                            End With
                        End With
                        With .DialogColumns.Add
                            Set myPatternDropdown = .Dropdowns.Add
                            With myPatternDropdown
                                .StringList = myStringList
                                .SelectedIndex = 0
                            End With
                        End With
                    End With
                End With
            End With
        End With
    End With
    myReturn = myDialog.Show
    If myReturn = True Then
        Rem Get the values from the dialog box.
        myCornerType = myCornerEffectButtons.SelectedButton
        myOffset = myOffsetEditbox.EditValue
        myPattern = myStringList(myPatternDropdown.SelectedIndex)
        myDialog.Destroy
        Rem Iterate through the objects.
        For myCounter = 0 To UBound(myObjectList)
            myChangeCorners myObjectList(myCounter), myCornerType, myOffset, myPattern
        Next
        Rem Reset the measurement units.
        myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = myOldXUnits
        myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = myOldYUnits
    Else
        myDialog.Destroy
    End If
End Function
Function myChangeCorners(myObject, myCornerType, myOffset, myPattern)
    For myPathCounter = 1 To myObject.Paths.Count
        Set myPath = myObject.Paths.Item(myPathCounter)
        ReDim myPointArray(0)
        For myPathPointCounter = 1 To myPath.PathPoints.Count
            Rem Is the point a qualifying point?
            If myPointTest(myPathPointCounter, myPath, myPattern) = False Then
                myX1 = myPath.PathPoints.Item(myPathPointCounter).LeftDirection(0)
                myY1 = myPath.PathPoints.Item(myPathPointCounter).LeftDirection(1)
                myX2 = myPath.PathPoints.Item(myPathPointCounter).Anchor(0)
                myY2 = myPath.PathPoints.Item(myPathPointCounter).Anchor(1)
                myX3 = myPath.PathPoints.Item(myPathPointCounter).RightDirection(0)
                myY3 = myPath.PathPoints.Item(myPathPointCounter).RightDirection(1)
                myPoint = Array(Array(myX1, myY1), Array(myX2, myY2), Array(myX3, myY3))
                If Not (IsEmpty(myPointArray(0))) Then
                    ReDim Preserve myPointArray(UBound(myPointArray) + 1)
                End If
                myPointArray(UBound(myPointArray)) = myPoint
            Else
                Set myPointA = myPath.PathPoints.Item(myPathPointCounter)
                myAnchor = myPointA.Anchor
                myX1 = myAnchor(0)
                myY1 = myAnchor(1)
                Rem myPointB is the *next* point on the path. If myPathPoint is the last point on the path, then
                Rem myPointB is the first point on the path.
                If myPathPointCounter = (myPath.PathPoints.Count) Then
                    Set myPointB = myPath.PathPoints.Item(1)
                Else
                    Set myPointB = myPath.PathPoints.Item(myPathPointCounter + 1)
                End If
                myAnchor = myPointB.Anchor
                myX2 = myAnchor(0)
                myY2 = myAnchor(1)
                Rem myPointC is the *previous* point on the path. If myPathPoint is the first point on the path,
                Rem then myPointC is the last point on the path.
                If myPathPointCounter = 1 Then
                    Set myPointC = myPath.PathPoints.Item(myPath.PathPoints.Count)
                Else
                    Set myPointC = myPath.PathPoints.Item(myPathPointCounter - 1)
                End If
                myAnchor = myPointC.Anchor
                myX3 = myAnchor(0)
                myY3 = myAnchor(1)
                myPoints = myAddPoints(myX1, myY1, myX2, myY2, myX3, myY3, myOffset)
                myNewX1 = myPoints(0)
                myNewY1 = myPoints(1)
                myNewX2 = myPoints(2)
                myNewY2 = myPoints(3)
                Rem Calculate new path point values based on the path effect type.
                Rem We won't add the points to the path one at a time instead, we'll
                Rem create an array that holds all of the point locations and curve
                Rem handle positions, and we will then
                Select Case myCornerType
                    Case 0
                        Rem Rounded corner effect.
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myX1, myY1))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                    Case 1:
                        Rem Inverse Rounded corner effect.
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myNewX2 + myNewX1 - myX1, myNewY2 + myNewY1 - myY1))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                    Case 2:
                        Rem Bevel corner effect.
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myNewX2, myNewY2))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                    Case 3:
                        Rem Inset corner effect.
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myNewX2, myNewY2))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX2 + myNewX1 - myX1, myNewY2 + myNewY1 - myY1), Array(myNewX2 + myNewX1 - myX1, myNewY2 + myNewY1 - myY1), Array(myNewX2 + myNewX1 - myX1, myNewY2 + myNewY1 - myY1))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                    Case 4:
                        Rem Fancy corner effect.
                        myOneThird = 0.33333333332
                        myTwoThirds = 0.666666666667
                        myPointZX = myNewX2 + myNewX1 - myX1
                        myPointZY = myNewY2 + myNewY1 - myY1
                        myTemp1X = (myX1 - myNewX2) * myTwoThirds
                        myTemp1Y = (myY1 - myNewY2) * myTwoThirds
                        myTemp2X = (myX1 - myNewX1) * myTwoThirds
                        myTemp2Y = (myY1 - myNewY1) * myTwoThirds
                        myPointDX = myPointZX + myOneThird * (myNewX1 - myPointZX)
                        myPointDY = myPointZY + myOneThird * (myNewY1 - myPointZY)
                        myPointEX = myPointZX + myOneThird * (myNewX2 - myPointZX)
                        myPointEY = myPointZY + myOneThird * (myNewY2 - myPointZY)
                        myPointFX = myPointDX + myTwoThirds * (myX1 - myTemp1X - myPointDX)
                        myPointFY = myPointDY + myTwoThirds * (myY1 - myTemp1Y - myPointDY)
                        myPointGX = myPointEX + myTwoThirds * (myX1 - myTemp2X - myPointEX)
                        myPointGY = myPointEY + myTwoThirds * (myY1 - myTemp2Y - myPointEY)
                        myPointHX = myPointZX + myTemp1X + myTemp2X
                        myPointHY = myPointZY + myTemp1Y + myTemp2Y
                        myPoint = Array(Array(myNewX2, myNewY2), Array(myNewX2, myNewY2), Array(myNewX2, myNewY2))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointEX, myPointEY), Array(myPointEX, myPointEY), Array(myPointEX, myPointEY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointGX, myPointGY), Array(myPointGX, myPointGY), Array(myPointGX, myPointGY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointHX, myPointHY), Array(myPointHX, myPointHY), Array(myPointHX, myPointHY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointFX, myPointFY), Array(myPointFX, myPointFY), Array(myPointFX, myPointFY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myPointDX, myPointDY), Array(myPointDX, myPointDY), Array(myPointDX, myPointDY))
                        myAddToArray myPointArray, myPoint
                        myPoint = Array(Array(myNewX1, myNewY1), Array(myNewX1, myNewY1), Array(myNewX1, myNewY1))
                        myAddToArray myPointArray, myPoint
                End Select
            End If
        Next
        myPath.EntirePath = myPointArray
    Next
End Function
Function myAddPoints(myX1, myY1, myX2, myY2, myX3, myY3, myOffset)
    myHypotenuse = Sqr(((myX1 - myX2) ^ 2) + ((myY1 - myY2) ^ 2))
    If myY1 <> myY2 Then
        myXAdjust = ((myX1 - myX2) / myHypotenuse) * myOffset
        myYAdjust = ((myY1 - myY2) / myHypotenuse) * myOffset
        myNewX1 = myX1 - myXAdjust
        myNewY1 = myY1 - myYAdjust
    Else
        myXAdjust = myOffset
        myYAdjust = 0
        If myX1 < myX2 Then
            myNewX1 = myX1 + myXAdjust
            myNewY1 = myY1 + myYAdjust
        Else
            myNewX1 = myX1 - myXAdjust
            myNewY1 = myY1 - myYAdjust
        End If
    End If
    myHypotenuse = Sqr(((myX1 - myX3) ^ 2) + ((myY1 - myY3) ^ 2))
    If myY1 <> myY3 Then
        myXAdjust = ((myX1 - myX3) / myHypotenuse) * myOffset
        myYAdjust = ((myY1 - myY3) / myHypotenuse) * myOffset
        myNewX2 = myX1 - myXAdjust
        myNewY2 = myY1 - myYAdjust
    Else
        myXAdjust = myOffset
        myYAdjust = 0
        If myX1 < myX3 Then
            myNewX2 = myX1 + myXAdjust
            myNewY2 = myY1 + myYAdjust
        Else
            myNewX2 = myX1 - myXAdjust
            myNewY2 = myY1 - myYAdjust
        End If
    End If
    myAddPoints = Array(myNewX1, myNewY1, myNewX2, myNewY2)
End Function
Function myPointTest(myPathPointCounter, myPath, myPattern)
    Rem Do not apply the corner effect to the first or last point in an open path
    Rem (this is the way that InDesign's corner effects work).
    If ((myPath.PathType = idPathType.idOpenPath) And ((myPathPointCounter = 0) Or (myPathPointCounter = myPath.PathPoints.Count))) Then
        myPointTest = False
        Exit Function
    Else
        Select Case myPattern
            Case "all points"
                myPointTest = True
                Exit Function
            Case "first point":
                If myPathPointCounter = 0 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "last point":
                If myPathPointCounter = myPath.PathPoints.Count Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "second point":
                If myPathPointCounter = 2 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "third point":
                If myPathPointCounter = 3 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "fourth point":
                If myPathPointCounter = 4 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "first two":
                If ((myPathPointCounter = 1) Or (myPathPointCounter = 2)) Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "second and third":
                If ((myPathPointCounter = 2) Or (myPathPointCounter = 3)) Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "last two":
                If ((myPathPointCounter = myPath.PathPoints.Count) Or (myPathPointCounter = (myPath.PathPoints.Count - 1))) Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "even points":
                If myPathPointCounter Mod 2 = 0 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
            Case "odd points":
                If myPathPointCounter Mod 2 <> 0 Then
                    myPointTest = True
                    Exit Function
                Else
                    myPointTest = False
                    Exit Function
                End If
        End Select
    End If
End Function
Function myAddToArray(myArray, myItem)
    If Not (IsEmpty(myArray(0))) Then
        ReDim Preserve myArray(UBound(myArray) + 1)
    End If
    If Not (IsObject(myItem)) Then
        myArray(UBound(myArray)) = myItem
    Else
        Set myArray(UBound(myArray)) = myItem
    End If
End Function
'' SIG '' Begin signature block
'' SIG '' MIIpyAYJKoZIhvcNAQcCoIIpuTCCKbUCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' 6ytBu3cvDoeRP1Cu5fPUN+DFB7ZYW5jkMUDfQrFP3tig
'' SIG '' gg6WMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
'' SIG '' 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
'' SIG '' WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
'' SIG '' hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
'' SIG '' XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
'' SIG '' 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
'' SIG '' ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
'' SIG '' ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
'' SIG '' GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
'' SIG '' XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
'' SIG '' GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
'' SIG '' R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
'' SIG '' wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
'' SIG '' k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
'' SIG '' M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
'' SIG '' UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
'' SIG '' FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
'' SIG '' JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
'' SIG '' 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
'' SIG '' CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
'' SIG '' CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
'' SIG '' upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
'' SIG '' BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
'' SIG '' BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
'' SIG '' QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
'' SIG '' cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
'' SIG '' DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
'' SIG '' 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
'' SIG '' fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
'' SIG '' WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
'' SIG '' YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
'' SIG '' WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
'' SIG '' Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
'' SIG '' H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
'' SIG '' 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
'' SIG '' 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
'' SIG '' 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
'' SIG '' i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
'' SIG '' KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
'' SIG '' bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
'' SIG '' ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
'' SIG '' SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
'' SIG '' VnhOMIIH3jCCBcagAwIBAgIQD99ExMbwCe2qSx8hp1o/
'' SIG '' EDANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTIzMTEw
'' SIG '' MzAwMDAwMFoXDTI1MTEwNDIzNTk1OVowgeYxEzARBgsr
'' SIG '' BgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIBAhMI
'' SIG '' RGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3JnYW5p
'' SIG '' emF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYDVQQG
'' SIG '' EwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNhbiBK
'' SIG '' b3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYDVQQL
'' SIG '' EyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29weSwg
'' SIG '' TXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCAiIwDQYJ
'' SIG '' KoZIhvcNAQEBBQADggIPADCCAgoCggIBAPCR5c/cgyg4
'' SIG '' MpJD46/+BWENPhE1RjN77VE2BWlIUdiO2nlWelKthEq9
'' SIG '' aK+1ofKIlDVc9mvxksuXBLESi7HBt3PCVBntNJkjBJd0
'' SIG '' EXeprmDK8HZrz8y/KSwEewbTMjneMRIRcJV2GMoAyUzK
'' SIG '' EyFJF7m6ByeoNBDDXMD4AQF5C2l3wfvRbREw+G+cyeya
'' SIG '' 564AHpFJ9sfqi9jAycnEZISxEf6N72GgGQr04cZt3JTb
'' SIG '' TktZGt6uWdZnseXDLGRHzFu4P4EqmVKvfMDliaKyWBzV
'' SIG '' lY+gmtE1vSxIK79WTySFrFY5j1vtbKyHybk6tv4TOmLt
'' SIG '' Lw4OP/ngVDiw/ZP+b7saGxPOEfuh5LOAr+llt+6V5NhT
'' SIG '' dkYPR6cbokawwX2DbGg7IeVuUPdf9bx/LznFV/8kPxCB
'' SIG '' J6qg0dqvCmQt/XbBXPJUvDoVJ9z+9hDlrAoLESqpHK8U
'' SIG '' 73UFGohBMJ/7itIyKngem7Ms98z6x0i63FJA8C06g+XE
'' SIG '' GJUmR28+c6ba+m/sc6xHI4zdL5a84UeRS9+u8UL8N4av
'' SIG '' fpSxHYTTxVjk1ZlwQ8dLARwEVWvTu4lRcEck3RPogx7o
'' SIG '' o8wUpSw9++m+Oi+K/z7RP/R67uCEtrkdM5N/xUoQR/t6
'' SIG '' 3P2ia9g8+LuYJ2BNBd1+qMcSoSlDfIFLFMeeqESbMv+j
'' SIG '' UsRQJn2lZvufAgMBAAGjggICMIIB/jAfBgNVHSMEGDAW
'' SIG '' gBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNVHQ4EFgQU
'' SIG '' RPnrJ9yT26rMrd/Q4PfQSlgeaRcwPQYDVR0gBDYwNDAy
'' SIG '' BgVngQwBAzApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbS9DUFMwDgYDVR0PAQH/BAQDAgeA
'' SIG '' MBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1BgNVHR8Ega0w
'' SIG '' gaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
'' SIG '' NDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOgUaBPhk1odHRw
'' SIG '' Oi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
'' SIG '' Q0ExLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBc
'' SIG '' BggrBgEFBQcwAoZQaHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25p
'' SIG '' bmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcnQwCQYDVR0T
'' SIG '' BAIwADANBgkqhkiG9w0BAQsFAAOCAgEAPIZ9C4IuKg85
'' SIG '' 0H8M66OLMVllIpANmEjijIG/D65qP6jfma+2WFps2bb+
'' SIG '' vKKIEtG9TFtCAlSrA1OV6Ru78paq0gqw/q3QAN0OleFR
'' SIG '' F1NvT/TLO0ulhjXTETB1BwSKZaJH001DH0+60TmbGfVh
'' SIG '' mwLrEj2Zfl4COFwivZ/2tRoknZl5tmiu4hpjDbOapWd9
'' SIG '' 5cqliSoMeu2i588557eikdiDk6bXBa5MxHjyXvbvaIWN
'' SIG '' Zjsymn0L0sYkF3BToDN0h0XiTTZjZPHdSV2GjX6C/+Nj
'' SIG '' HSZGRtBaIxdAL1mKEWJV9qkEKELPb098rO+zGdn1E5IH
'' SIG '' pS1zSRIYngwZEjZfyoCkg1F+EW4QPs2+ff2CsW5i3IEd
'' SIG '' 7vL19w9oyce3S4wejvnlTKt+EQWn3gSPxrbkp3BxdWRN
'' SIG '' 25MKo5bS5bJ21BiwqcIJHcTxWNgaQPh4sZboi9IimCSn
'' SIG '' UenPQhqdeOuz0NnmepMEYd7L/kqnAeUZ8bW1UbITAWQ/
'' SIG '' UT3phjCfRQNpEh4OBoUcH8hOOHZ0Lh86mxv9lDP3i7c/
'' SIG '' bQzZnrJr2dS34JXolwREbTX9Yu5JB5X3YP539/M1Ms5O
'' SIG '' FZou/MHQBrWMsVBsEXDTWqwbMTYw/zvIiHXcGUnpzInw
'' SIG '' 1jQXlLrmwVHW4ug+A4LFO7bWC4mnZoDNWp0xnlGmbP6I
'' SIG '' ccJmW5C7RJMxghqKMIIahgIBATB9MGkxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8G
'' SIG '' A1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNp
'' SIG '' Z25pbmcgUlNBNDA5NiBTSEEzODQgMjAyMSBDQTECEA/f
'' SIG '' RMTG8AntqksfIadaPxAwDQYJYIZIAWUDBAIBBQCggZww
'' SIG '' GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
'' SIG '' BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcN
'' SIG '' AQkEMSIEIBMd+oiPS5Bs+I9PfQ+mjFSQOe+E0Hu0Ocjx
'' SIG '' ciXxnkt2MDAGCisGAQQBgjcCAQwxIjAgoB6AHABBAGQA
'' SIG '' bwBiAGUAIABJAG4ARABlAHMAaQBnAG4wDQYJKoZIhvcN
'' SIG '' AQEBBQAEggIAYafO4nyWWWlFitPHgwTfn772WaePr60F
'' SIG '' Utqd4XxNMSKPjScDav2rTDkJkNVS9Djz05sH7o4afzYR
'' SIG '' g5yLCq0RmA8B7Gzn5WhPzPflKq7tN8eS02Sznr6eKmnT
'' SIG '' 0sg1GtgFLaNzcjBm/NhfRM+WM+7VAn0kxa5cxLLoZmpC
'' SIG '' xg6LdLAHNmp9c6BhID7f3uRBp/Zv1KLRS+vCIeot9O5z
'' SIG '' iu6V5WPNiJZ0itRV+t32jFYsfEHl3wG3tZsHW0OJOpox
'' SIG '' Up76evKHS0trkOADIWeZ4YZLT0KcbEUIui8o2pz9j0mK
'' SIG '' PctAMWnITTaW7SlMc55q7waerdMOiY1TNVMcVwNPHKj2
'' SIG '' gmFKNpqgv2Vu+5d6T8/ArB9EqfBNllG9h07G/PsK1jwb
'' SIG '' 5MshgMOi8so6tQJqbGl6rnoefM5FDvtjmiTPPjksHV5l
'' SIG '' cNfIs2gisPelDKuUu0R0Wtijr1D4DBxpeu0Hw/H07cr2
'' SIG '' Xf0aD4O7a8lnWjSd1icZH6KVoNv3lJfer4sA3MuqMBrG
'' SIG '' 9fBJ8WQnxyXav8Y3xXAT4syGAH5Kog1wTwTK/mjd2cJh
'' SIG '' Kofal4JiApaduZK8oVoeHJiHAzwQKI3dgqGJhwI+pym5
'' SIG '' DN2J+zX5PNpPwev05VhmknzDLCwh4Y2lCdzNCQr2AJkc
'' SIG '' T22uvMrMY7CMG+HOXFXyeBVtHXLRB7Jw/5Chghc/MIIX
'' SIG '' OwYKKwYBBAGCNwMDATGCFyswghcnBgkqhkiG9w0BBwKg
'' SIG '' ghcYMIIXFAIBAzEPMA0GCWCGSAFlAwQCAQUAMHcGCyqG
'' SIG '' SIb3DQEJEAEEoGgEZjBkAgEBBglghkgBhv1sBwEwMTAN
'' SIG '' BglghkgBZQMEAgEFAAQguNNXGo0w7CT4GOMhjSBTBo3U
'' SIG '' c2y0zk3VohuTvE0P6ZACEBSv8vfrj4AHV54nKVP4pCQY
'' SIG '' DzIwMjQwMTI2MjM1NDQxWqCCEwkwggbCMIIEqqADAgEC
'' SIG '' AhAFRK/zlJ0IOaa/2z9f5WEWMA0GCSqGSIb3DQEBCwUA
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0EwHhcNMjMwNzE0MDAwMDAwWhcNMzQxMDEzMjM1OTU5
'' SIG '' WjBIMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNl
'' SIG '' cnQsIEluYy4xIDAeBgNVBAMTF0RpZ2lDZXJ0IFRpbWVz
'' SIG '' dGFtcCAyMDIzMIICIjANBgkqhkiG9w0BAQEFAAOCAg8A
'' SIG '' MIICCgKCAgEAo1NFhx2DjlusPlSzI+DPn9fl0uddoQ4J
'' SIG '' 3C9Io5d6OyqcZ9xiFVjBqZMRp82qsmrdECmKHmJjadNY
'' SIG '' nDVxvzqX65RQjxwg6seaOy+WZuNp52n+W8PWKyAcwZeU
'' SIG '' tKVQgfLPywemMGjKg0La/H8JJJSkghraarrYO8pd3hkY
'' SIG '' hftF6g1hbJ3+cV7EBpo88MUueQ8bZlLjyNY+X9pD04T1
'' SIG '' 0Mf2SC1eRXWWdf7dEKEbg8G45lKVtUfXeCk5a+B4WZfj
'' SIG '' RCtK1ZXO7wgX6oJkTf8j48qG7rSkIWRw69XloNpjsy7p
'' SIG '' Be6q9iT1HbybHLK3X9/w7nZ9MZllR1WdSiQvrCuXvp/k
'' SIG '' /XtzPjLuUjT71Lvr1KAsNJvj3m5kGQc3AZEPHLVRzapM
'' SIG '' ZoOIaGK7vEEbeBlt5NkP4FhB+9ixLOFRr7StFQYU6mII
'' SIG '' E9NpHnxkTZ0P387RXoyqq1AVybPKvNfEO2hEo6U7Qv1z
'' SIG '' fe7dCv95NBB+plwKWEwAPoVpdceDZNZ1zY8SdlalJPrX
'' SIG '' xGshuugfNJgvOuprAbD3+yqG7HtSOKmYCaFxsmxxrz64
'' SIG '' b5bV4RAT/mFHCoz+8LbH1cfebCTwv0KCyqBxPZySkwS0
'' SIG '' aXAnDU+3tTbRyV8IpHCj7ArxES5k4MsiK8rxKBMhSVF+
'' SIG '' BmbTO77665E42FEHypS34lCh8zrTioPLQHsCAwEAAaOC
'' SIG '' AYswggGHMA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8E
'' SIG '' AjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMCAGA1Ud
'' SIG '' IAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAfBgNV
'' SIG '' HSMEGDAWgBS6FtltTYUvcyl2mi91jGogj57IbzAdBgNV
'' SIG '' HQ4EFgQUpbbvE+fvzdBkodVWqWUxo97V40kwWgYDVR0f
'' SIG '' BFMwUTBPoE2gS4ZJaHR0cDovL2NybDMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZEc0UlNBNDA5NlNIQTI1
'' SIG '' NlRpbWVTdGFtcGluZ0NBLmNybDCBkAYIKwYBBQUHAQEE
'' SIG '' gYMwgYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRp
'' SIG '' Z2ljZXJ0LmNvbTBYBggrBgEFBQcwAoZMaHR0cDovL2Nh
'' SIG '' Y2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3Rl
'' SIG '' ZEc0UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNy
'' SIG '' dDANBgkqhkiG9w0BAQsFAAOCAgEAgRrW3qCptZgXvHCN
'' SIG '' T4o8aJzYJf/LLOTN6l0ikuyMIgKpuM+AqNnn48XtJoKK
'' SIG '' cS8Y3U623mzX4WCcK+3tPUiOuGu6fF29wmE3aEl3o+uQ
'' SIG '' qhLXJ4Xzjh6S2sJAOJ9dyKAuJXglnSoFeoQpmLZXeY/b
'' SIG '' JlYrsPOnvTcM2Jh2T1a5UsK2nTipgedtQVyMadG5K8TG
'' SIG '' e8+c+njikxp2oml101DkRBK+IA2eqUTQ+OVJdwhaIcW0
'' SIG '' z5iVGlS6ubzBaRm6zxbygzc0brBBJt3eWpdPM43UjXd9
'' SIG '' dUWhpVgmagNF3tlQtVCMr1a9TMXhRsUo063nQwBw3syY
'' SIG '' nhmJA+rUkTfvTVLzyWAhxFZH7doRS4wyw4jmWOK22z75
'' SIG '' X7BC1o/jF5HRqsBV44a/rCcsQdCaM0qoNtS5cpZ+l3k4
'' SIG '' SF/Kwtw9Mt911jZnWon49qfH5U81PAC9vpwqbHkB3NpE
'' SIG '' 5jreODsHXjlY9HxzMVWggBHLFAx+rrz+pOt5Zapo1iLK
'' SIG '' O+uagjVXKBbLafIymrLS2Dq4sUaGa7oX/cR3bBVsrquv
'' SIG '' czroSUa31X/MtjjA2Owc9bahuEMs305MfR5ocMB3CtQC
'' SIG '' 4Fxguyj/OOVSWtasFyIjTvTs0xf7UGv/B3cfcZdEQcm4
'' SIG '' RtNsMnxYL2dHZeUbc7aZ+WssBkbvQR7w8F/g29mtkIBE
'' SIG '' r4AQQYowggauMIIElqADAgECAhAHNje3JFR82Ees/Shm
'' SIG '' Kl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYTAlVT
'' SIG '' MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsT
'' SIG '' EHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lD
'' SIG '' ZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMwMDAw
'' SIG '' MDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVT
'' SIG '' MRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UE
'' SIG '' AxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNI
'' SIG '' QTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3
'' SIG '' DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXH
'' SIG '' JQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVCX6SI
'' SIG '' 82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0hNoR
'' SIG '' 8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU
'' SIG '' 5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ3Hxq
'' SIG '' V3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43IbtA
'' SIG '' rF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECn
'' SIG '' wHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcplicu
'' SIG '' 9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6OBGz
'' SIG '' 9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpUR
'' SIG '' K1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD
'' SIG '' 4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB7UK/
'' SIG '' BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T
'' SIG '' /jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uK
'' SIG '' IqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbsq11G
'' SIG '' deJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5rmQzS
'' SIG '' M7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB
'' SIG '' /wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxqII+e
'' SIG '' yG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4c
'' SIG '' D08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsG
'' SIG '' AQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsG
'' SIG '' AQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNV
'' SIG '' HR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAg
'' SIG '' BgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEw
'' SIG '' DQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQiAX5m
'' SIG '' 1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxp
'' SIG '' wc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGId
'' SIG '' DAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+KLHqr
'' SIG '' hc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQcAp8
'' SIG '' 76i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeC
'' SIG '' RK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SNoOeY
'' SIG '' +/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3ZpHx
'' SIG '' cpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fx
'' SIG '' ZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr5Dhz
'' SIG '' q6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j/R0o
'' SIG '' 08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1Oby
'' SIG '' F5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCYoCvt
'' SIG '' lUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y3wSJ
'' SIG '' 8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8
'' SIG '' mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt
'' SIG '' 1nz8MIIFjTCCBHWgAwIBAgIQDpsYjvnQLefv21DiCEAY
'' SIG '' WjANBgkqhkiG9w0BAQwFADBlMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2Vy
'' SIG '' dCBBc3N1cmVkIElEIFJvb3QgQ0EwHhcNMjIwODAxMDAw
'' SIG '' MDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJV
'' SIG '' UzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQL
'' SIG '' ExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdp
'' SIG '' Q2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
'' SIG '' DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAi
'' SIG '' MGkz7MKnJS7JIT3yithZwuEppz1Yq3aaza57G4QNxDAf
'' SIG '' 8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4VpX6+
'' SIG '' n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7
'' SIG '' bXHiLQwb7iDVySAdYyktzuxeTsiT+CFhmzTrBcZe7Fsa
'' SIG '' vOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3T6cw2Vbu
'' SIG '' yntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHE
'' SIG '' tWoYOAMQjdjUN6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6R
'' SIG '' AXwhTNS8rhsDdV14Ztk6MUSaM0C/CNdaSaTC5qmgZ92k
'' SIG '' J7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI
'' SIG '' 8OCiEhtmmnTK3kse5w5jrubU75KSOp493ADkRSWJtppE
'' SIG '' GSt+wJS00mFt6zPZxd9LBADMfRyVw4/3IbKyEbe7f/LV
'' SIG '' jHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QY
'' SIG '' uKZ3AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+N
'' SIG '' P8m800ERElvlEFDrMcXKchYiCd98THU/Y+whX8QgUWtv
'' SIG '' sauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
'' SIG '' sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB
'' SIG '' /zAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5nP+e6mK4cD08w
'' SIG '' HwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8w
'' SIG '' DgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAk
'' SIG '' BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQu
'' SIG '' Y29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5k
'' SIG '' aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290
'' SIG '' Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9j
'' SIG '' cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJ
'' SIG '' RFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0G
'' SIG '' CSqGSIb3DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW
'' SIG '' 1/e/Vwe9mqyhhyzshV6pGrsi+IcaaVQi7aSId229GhT0
'' SIG '' E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n0
'' SIG '' 96wwepqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE
'' SIG '' 1Od/6Fmo8L8vC6bp8jQ87PcDx4eo0kxAGTVGamlUsLih
'' SIG '' Vo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
'' SIG '' jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt
'' SIG '' 9H5xaiNrIv8SuFQtJ37YOtnwtoeW/VvRXKwYw02fc7cB
'' SIG '' qZ9Xql4o4rmUMYIDdjCCA3ICAQEwdzBjMQswCQYDVQQG
'' SIG '' EwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5
'' SIG '' BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5
'' SIG '' NiBTSEEyNTYgVGltZVN0YW1waW5nIENBAhAFRK/zlJ0I
'' SIG '' Oaa/2z9f5WEWMA0GCWCGSAFlAwQCAQUAoIHRMBoGCSqG
'' SIG '' SIb3DQEJAzENBgsqhkiG9w0BCRABBDAcBgkqhkiG9w0B
'' SIG '' CQUxDxcNMjQwMTI2MjM1NDQxWjArBgsqhkiG9w0BCRAC
'' SIG '' DDEcMBowGDAWBBRm8CsywsLJD4JdzqqKycZPGZzPQDAv
'' SIG '' BgkqhkiG9w0BCQQxIgQgvzBsfFXaskQeeANbOazTr5ra
'' SIG '' Bo3M38XNH6GirD8gAEwwNwYLKoZIhvcNAQkQAi8xKDAm
'' SIG '' MCQwIgQg0vbkbe10IszR1EBXaEE2b4KK2lWarjMWr00a
'' SIG '' mtQMeCgwDQYJKoZIhvcNAQEBBQAEggIAab8aZ2BwCbWq
'' SIG '' Y1QD5y8tY1TKkmiWD7i4ZtfTPVMOcbb7r/TztL4TYMi7
'' SIG '' kp7wzcHbtp/IEls3b3NIflvmQ4MwmTowt20833RjONZP
'' SIG '' HpDsnCPoNvAOgQi1Uu7ShdLpLAzpvTOdq7kyPDpBvP+p
'' SIG '' e1dIHIzxSpzYUY68ZiGrtazXUdsaGyre7Xd5tldmimvO
'' SIG '' 5dUlHKRkuiBrfJCyV7U/bwOgw8oesvh86JBAebx4TTqm
'' SIG '' ymYmqt8rmkNdUUIQ3jPOiYYqb/Nsijo+oRhohykrkkxR
'' SIG '' crNb0uHgEjcJHnhsRLue6yAmVgPtXDmfpL5bWgv7Cfxd
'' SIG '' s1gKkJ7QTBDBo43uUi0fG0pBo2blrSX++cnXK9Ij4ml3
'' SIG '' rt/pNvV+FnaqQfm4/12Mjs/FQzl7UMQ/WEfHI/WhLKj3
'' SIG '' W9PoQNXNA4467cBYZju8L4zgaOFqI8nDhEqAsG0HMROZ
'' SIG '' VNJelhBwtp1t/3Id29CW9cMFDFuNdppXizju2aLNgL+s
'' SIG '' rgo0InsHe3yb09rq2JHyFhnkBWxIlkNW46JLNx3D0x9D
'' SIG '' x7FvMEMUYMpdfzte/QqSq2RpQ93cwIkXnpaC76CSsx6B
'' SIG '' RyK2H14sYWVRUug0ZE/o7vrms2cJbGwbzlGagKAdiY3a
'' SIG '' otZZ+yUPx4QAKe/wfIP67bohngokHMbiECIDnWPXXDxs
'' SIG '' /bFaKpsKYdw=
'' SIG '' End signature block
